IF OBJECT_ID('P_EST_PROD_AGENDA_COMPRA ') IS NOT NULL
BEGIN
	DROP PROCEDURE P_EST_PROD_AGENDA_COMPRA 
END
go

--P_EST_PROD_AGENDA_COMPRA @RELA_CD_PROD='10200', @CD_FILIAL='2'
CREATE PROCEDURE P_EST_PROD_AGENDA_COMPRA  (@CD_EMP  			    TINYINT = 1, 
											@CD_AGENDA        	    INT = 0,
											@CD_DEPOSITOS           VARCHAR (100) = '',
											@CD_USU                 INT = 1,
											@LISTA_PRECO            VARCHAR(MAX) = '',
											@CD_SIGLA_CURVA         VARCHAR(100) = '1,2,3,4,5',
											@CONSIDERA_FACE         TINYINT = 1,
											@PED_QTD_DEF            TINYINT        = 0,
											@RELA_CD_PROD           VARCHAR(max) = '',
											@TIPO_COMPRA            VARCHAR(20) = NULL,
											@TIPO_VAN_COMPRA        VARCHAR(20) = '',
											@CD_FILIAL              VARCHAR(max) = '',
											@PAR_EST_AA             MONEY = NULL,
											@PAR_EST_A              MONEY = NULL,
											@PAR_EST_B              MONEY = NULL,
											@PAR_EST_C              MONEY = NULL,
											@PAR_EST_D              MONEY = NULL,
											@CD_DEPO_ENTREGA        INT = 0,
											@NAO_UTILIZA_AGD_FACE   TINYINT = 0,
											@PAR_EST_AA_VLR         MONEY = NULL,
											@PAR_EST_A_VLR          MONEY = NULL,
											@PAR_EST_B_VLR          MONEY = NULL,
											@PAR_EST_C_VLR          MONEY = NULL,
											@PAR_EST_D_VLR          MONEY = NULL,
											@TP_REQ 			    INT = 0,
											@LEAD_TIME 			    INT = 0,
											@DT_PROX_AGENDA 	    DATETIME = NULL,
											@ACRES_DIAS_PROX_AGENDA INT = 0,
											@IGNORAR_EXCESSO 		INT = 0,
											@EXIBIR_PRODUTOS_SEM_DEMANDA TINYINT = 0)
--WITH ENCRYPTION, RECOMPILE 
AS 
SET NOCOUNT ON;
SET DEADLOCK_PRIORITY HIGH;
 
/***********************************************************************************************/
--                                                                        P_EST_PROD_AGENDA_COMPRA 
/***********************************************************************************************//*
        Rotina de compras por agenda
        by Ramam Freitas - 22/07/2016
        Recebe:  
                        @CD_EMP                        tinyint -> Codigo da empresa  - Obrigatorio
                        @CD_AGENDA                int                -> Codigo da agenda   
                        @CD_DEPOSITOS        varchar        -> Codigo dos depositos para considerar o estoque
                        @CD_USU                        int                -> Codigo da usuario da demanda
                        @LISTA_PRECO        varchar        -> Listas de preco para utilizar na demanda
                        @CD_SIGLA_CURVA        varchar        -> Relacao de curvas
                        @CONSIDERA_FACE        tinyint        -> Indicativo de considerar faceamento
                        @PED_QTD_DEF        tinyint        -> Define se trata-se de uma demanda com quantidades ja definidas
                        @TIPO_COMPRA        varchar        -> Tipo de compra (Suprimento Ressuprimento, Supressup) 0-Ressuprimento 1-Suprimento 2 Sup-Ressup
                        @TIPO_VAN_COMPRA varchar        -> Processo de van de compras(Pharmalink,Entire,Fidelize)
        Obs.:        
                Caso nao seja informado o @CD_AGENDA deverá ser passada a relacao de produtos (@RELA_CD_PROD).
***********************************************************************************************/
-- Variaveis da rotina
/***********************************************************************************************/
 
 /*
 DROP TABLE PARAM_TEMP;
CREATE TABLE PARAM_TEMP( CD_EMP                                TINYINT, 
                                                        CD_AGENDA                        INT ,
                                                        CD_DEPOSITOS                VARCHAR (100) ,
                                                        CD_USU                                INT ,
                                                        LISTA_PRECO                VARCHAR(MAX) ,
                                                        CD_SIGLA_CURVA                VARCHAR(100),
                                                        CONSIDERA_FACE                TINYINT,
                                                        PED_QTD_DEF                TINYINT        ,
                                                        RELA_CD_PROD                VARCHAR(max),
                                                        TIPO_COMPRA                VARCHAR(20),
                                                        TIPO_VAN_COMPRA        VARCHAR(20),
                                                        CD_FILIAL                VARCHAR(max),
                                                        PAR_EST_AA         MONEY,
                                                        PAR_EST_A                 MONEY,
                                                        PAR_EST_B                 MONEY,
                                                        PAR_EST_C                 MONEY,
                                                        PAR_EST_D                MONEY,
                                                        CD_DEPO_ENTREGA                                INT )
 
 
INSERT INTO PARAM_TEMP
SELECT
        @CD_EMP                                , 
        @CD_AGENDA                        ,
        @CD_DEPOSITOS                ,
        @CD_USU                                ,
        @LISTA_PRECO                ,
        @CD_SIGLA_CURVA                ,
        @CONSIDERA_FACE                ,
        @PED_QTD_DEF                ,
        @RELA_CD_PROD                ,
        @TIPO_COMPRA                ,
        @TIPO_VAN_COMPRA        ,
        @CD_FILIAL                ,
        @PAR_EST_AA         ,
        @PAR_EST_A                 ,
        @PAR_EST_B                 ,
        @PAR_EST_C                 ,
        @PAR_EST_D                ,
        @CD_DEPO_ENTREGA
        */
 
--Limpa tabela 
UPDATE C
        SET C.STS_UTILIZADO = 0
FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA A
INNER JOIN EST_PROD_SUPRIMENTO_ENCOMENDA_ENTREGA_LOJA B ON A.CD_USU = B.CD_USU AND A.CD_EMP = B.CD_EMP
INNER JOIN EST_PROD_SUPRIMENTO_ENCOMENDA C ON A.CD_PROD = C.CD_PROD AND A.CD_FILIAL = C.CD_FILIAL AND B.CD_CTR = C.CD_CTR
WHERE A.CD_EMP = @CD_EMP AND A.CD_USU = @CD_USU AND A.FLAG_PROD_INSERIDO_USUARIO = 2 AND C.STS_UTILIZADO = 1
DELETE FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_HIST WHERE CD_USU = @CD_USU
DELETE FROM EST_PROD_SUPRIMENTO_ENCOMENDA_ENTREGA_LOJA WHERE CD_EMP = @CD_EMP AND CD_USU = @CD_USU
DELETE FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA WHERE  CD_EMP = @CD_EMP AND CD_USU = @CD_USU
DELETE FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_PARAM WHERE  CD_EMP = @CD_EMP AND CD_USU = @CD_USU

-----------------------------------------------------------------------------------------
Print 'Inicio da rotina P_EST_PROD_AGENDA_COMPRA - Time ' + convert(varchar, getdate(),108);
DECLARE @FREQ_REV        tinyint,
                @TIPO_FRETE        tinyint,
                @COMPRA_EMBALADO        tinyint,
                @COMPRA_MULTIPLO        tinyint,
                @PERC_DESC_COMERCIAL        money,
                @PERC_DESC_FINANCEIRO        money,
                @PRZ_PGTO        tinyint,
                @SEGUNDA        tinyint,
                @TERCA        tinyint,
                @QUARTA        tinyint,
                @QUINTA        tinyint,
                @SEXTA        tinyint,
                @SABADO        tinyint,
                @DOMINGO        tinyint,
                @PARAM_EST        tinyint,
                @DT_AGENDAMENTO_DEFAULT        datetime,
                @INDICADOR_SUPRIMENTO        tinyint,
                @QT_DIAS_ACRES_AGENDA        int,
                @DT_VALID_ACRES_AGENDA        datetime,
                @FLAG_GERAR_AGENDA        tinyint,
                @FLAG_EXPORTA_NEOGRID        tinyint,
                @FLAG_LST_PRECO        tinyint,
                @FLAG_GRUPO_POSSUI_PRODUTOS        tinyint,
                @STS_AGENDA        tinyint,
                @CD_COMPRADOR        int,
                @TIPO_AGENDA        tinyint,
                @MES        tinyint,
                @ANO        int,
                @CONSIDERA_EST_CD INT,
                @CompraBandeira tinyint,
                @Considera_eseg TinyInt,
                @FLAG_NAO_ENVIAR_PBM tinyint,
                @SqlTxt varchar(max);
/***********************************************************************************************/
-- Carga dos parametros da rotina.
/***********************************************************************************************/
		if @PED_QTD_DEF IN (1,2)
		begin
           set @CD_SIGLA_CURVA='1,2,3,4,5';
	   end
		   
        SET @CompraBandeira = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG 
                                                                        WHERE  CD_CHAVE = 'CADASTRA_PRODUTO_POR_BANDEIRA' AND VALOR ='1'),0);                                                                
        SET @Considera_eseg = isnull((SELECT valor FROM dbo.PRC_EMP_CONFIG pec 
                                                                        WHERE cd_chave ='CONSIDERAR_ESEG_NECESSIDADE_DIRETO_LOJA'),0);
        if @CD_AGENDA > 0 
        begin
                set @CD_SIGLA_CURVA='1,2,3,4,5'
                SELECT 
                        @FREQ_REV=FREQ_REV,
                        @LEAD_TIME=CASE WHEN @LEAD_TIME = NULL THEN LEAD_TIME ELSE @LEAD_TIME END,
                        @TIPO_FRETE=TIPO_FRETE,
                        @COMPRA_EMBALADO=COMPRA_EMBALADO,
                        @COMPRA_MULTIPLO=COMPRA_MULTIPLO,
                        @PERC_DESC_COMERCIAL=PERC_DESC_COMERCIAL,
                        @PERC_DESC_FINANCEIRO=PERC_DESC_FINANCEIRO,
                        @PRZ_PGTO=PRZ_PGTO,
                        @SEGUNDA=SEGUNDA,
                        @TERCA=TERCA,
                        @QUARTA=QUARTA,
                        @QUINTA=QUINTA,
                        @SEXTA=SEXTA,
                        @SABADO=SABADO,
                        @DOMINGO=DOMINGO,
                        @PARAM_EST=PARAM_EST+LEAD_TIME,
                        @DT_AGENDAMENTO_DEFAULT=DT_AGENDAMENTO_DEFAULT,
                        @INDICADOR_SUPRIMENTO=INDICADOR_SUPRIMENTO,
                        @TIPO_COMPRA= convert(varchar(20),TIPO_COMPRA),
                        @QT_DIAS_ACRES_AGENDA=QT_DIAS_ACRES_AGENDA,
                        @DT_VALID_ACRES_AGENDA=DT_VALID_ACRES_AGENDA,
                        @FLAG_GERAR_AGENDA=FLAG_GERAR_AGENDA,
                        @FLAG_EXPORTA_NEOGRID=FLAG_EXPORTA_NEOGRID,
                        @FLAG_LST_PRECO=FLAG_LST_PRECO,
                        @FLAG_GRUPO_POSSUI_PRODUTOS=FLAG_GRUPO_POSSUI_PRODUTOS,
                        @STS_AGENDA=STS_AGENDA,
                        @CD_COMPRADOR=CD_COMPRADOR,
                        @TIPO_AGENDA=TIPO_AGENDA,
                        @MES = DATEPART(MONTH,GETDATE()),
                        @ANO = DATEPART(YEAR,GETDATE()),
                        @PAR_EST_AA = coalesce( @PAR_EST_AA,PARAM_EST+LEAD_TIME,0),
                        @PAR_EST_A =  coalesce( @PAR_EST_A,PARAM_EST+LEAD_TIME,0),
                        @PAR_EST_B =  coalesce( @PAR_EST_B,PARAM_EST+LEAD_TIME,0),
                        @PAR_EST_C =  coalesce( @PAR_EST_C,PARAM_EST+LEAD_TIME,0),
                        @PAR_EST_D =  coalesce( @PAR_EST_D,PARAM_EST+LEAD_TIME,0),
                        @FLAG_NAO_ENVIAR_PBM = FLAG_NAO_ENVIAR_PBM
                from EST_PROD_AGENDA_COMPRA
                where
                        CD_CTR_AGENDA=@CD_AGENDA;
						
                if @@rowcount=0
                begin
                        Print 'Nenhuma agenda encontrada ';
                        return
                end
				
                if @INDICADOR_SUPRIMENTO = 1 
                begin
                        Print 'Agenda inativa';
                        return
                end
				
				if @TIPO_AGENDA=2 
                begin
                        Print 'Agenda de ressuprimento';
                        return
                end
				
                if @TIPO_COMPRA is null
                        set @TIPO_COMPRA = '6';
						
				if @TIPO_COMPRA = '' 
                        set @TIPO_COMPRA='6';
						
                if @TIPO_COMPRA = '6' 
                begin
                        if @TIPO_AGENDA=1 --Suprimento
                        begin
                                set @TIPO_COMPRA='1,2';
                        end
                        if @TIPO_AGENDA=3 --Ressuprimento Forn
                        begin
                                set @TIPO_COMPRA='0,2';
                        end
                end
                if @TIPO_COMPRA = '1' 
                begin
                        set @TIPO_COMPRA='1,2';
                end
                if @TIPO_COMPRA = '2' 
                begin
                        set @TIPO_COMPRA='0,2';
                end
                if @TIPO_COMPRA = '3' 
                begin
                        set @TIPO_COMPRA='1';
                end
                if @TIPO_COMPRA = '4' 
                begin
                        set @TIPO_COMPRA='0';
                end
                if @TIPO_COMPRA = '5' 
                begin
                        set @TIPO_COMPRA='2';
                end
        end
        else
        begin
                if @TIPO_COMPRA is null
                        set @TIPO_COMPRA = ''
                SELECT 
                        @FREQ_REV=0,
                        @LEAD_TIME= CASE WHEN @LEAD_TIME = NULL THEN 0 ELSE @LEAD_TIME END,
                        @TIPO_FRETE=0,
                        @COMPRA_EMBALADO=0,
                        @COMPRA_MULTIPLO=0,
                        @PERC_DESC_COMERCIAL=0,
                        @PERC_DESC_FINANCEIRO=0,
                        @PRZ_PGTO=0,
                        @SEGUNDA=1,
                        @TERCA=1,
                        @QUARTA=1,
                        @QUINTA=1,
                        @SEXTA=1,
                        @SABADO=1,
                        @DOMINGO=1,
                        @PARAM_EST=10,
                        @DT_AGENDAMENTO_DEFAULT=getdate(),
                        @INDICADOR_SUPRIMENTO=0,
                        @QT_DIAS_ACRES_AGENDA=0,
                        @DT_VALID_ACRES_AGENDA=getdate(),
                        @FLAG_GERAR_AGENDA=0,
                        @FLAG_EXPORTA_NEOGRID=0,
                        @FLAG_LST_PRECO=0,
                        @FLAG_GRUPO_POSSUI_PRODUTOS=0,
                        @STS_AGENDA=1,
                        @CD_COMPRADOR=1,
                        @TIPO_AGENDA=1,
                        @MES = DATEPART(MONTH,GETDATE()),
                        @ANO = DATEPART(YEAR,GETDATE())
        end
        
         
IF  OBJECT_ID('TEMPDB.DBO.#RS_AGD_FACE') IS NOT NULL
        DROP TABLE #RS_AGD_FACE
IF  OBJECT_ID('TEMPDB.DBO.#RS_SIGLA') IS NOT NULL
        DROP TABLE #RS_SIGLA
IF  OBJECT_ID('TEMPDB.DBO.#RS_LISTA_PRECO ') IS NOT NULL
        DROP TABLE #RS_LISTA_PRECO 
--select 
--        @PARAM_EST,        
--        @PAR_EST_AA,
--        @PAR_EST_A,
--        @PAR_EST_B,
--        @PAR_EST_C,
--        @PAR_EST_D 
        CREATE TABLE #RS_SIGLA (CD_SIGLA INT)
        CREATE TABLE #RS_AGD_FACE (CD_EMP INT, CD_AGD INT);
		CREATE TABLE #RS_AGD_FACE_PROD (CD_EMP INT, CD_FILIAL INT, CD_PROD INT, QTDE_FACE MONEY);

        CREATE TABLE #RS_LISTA_PRECO (CD_COND_COMPRA INT,CD_PROD INT,VLR_PROD MONEY, PERC_DESC MONEY);  
        CREATE TABLE #RS_AUXRAT ( CD_FILIAL                INT,
                                                                        CD_PROD                INT,
                                                                        EMAX                        MONEY,
                                                                        QMIN                        MONEY,
                                                                        QTDE_MEDIAF        MONEY,
                                                                        QT_EST                MONEY,
                                                                        QTDE_RESSUP        MONEY, 
                                                                        MEDIAF                MONEY,
                                                                        FLAG_RESSUPRIMENTO_CAIXA_FECHADA        INT,
                                                                        QT_UNI_RESSUPRIMENTO                                INT,
                                                                        FLAG_RATEIO                                INT,
                                                                        QT_EST_CD_DISP                        MONEY,
                                                                        QT_NECESSIDADE                        MONEY,
                                                                        QT_EST_MTZ                                MONEY
                                                                        PRIMARY KEY (CD_FILIAL,CD_PROD));
                                                                        
        CREATE TABLE #RS_PROD_CONSOLIDADO ( CD_PROD                                                                        INT,
                                                                                        QT_UNI_RESSUPRIMENTO                                INT,
                                                                                        FLAG_RESSUPRIMENTO_CAIXA_FECHADA        INT, 
                                                                                        QT_EST_FILIAIS_SOMA                                        MONEY,
                                                                                        QT_MEDIAF_SOMA                                                MONEY,
                                                                                        QT_RESSUP_SOMA                                                MONEY,
                                                                                        QT_NECESSIDADE_FILIAIS                                MONEY,
                                                                                        QT_DEPOSITO_INICIO                                        MONEY,
                                                                                        QT_DEPOSITO                                                        MONEY,
                                                                                        FLAG_RATEIO                                                        INT,
                                                                                        QT_EST_CD_DISP_SOMA                                        MONEY);
--Curvas 
INSERT INTO #RS_SIGLA
SELECT 
         ID 
FROM UFD_PRM_IN_STRING(@CD_SIGLA_CURVA); 
Print 'Carregou parametros da agenda - Time ' + convert(varchar, getdate(),108);
 
/***********************************************************************************************/
-- Filiais
/***********************************************************************************************/ 
IF  OBJECT_ID('TEMPDB.DBO.#TMP_FILIAL') IS NOT NULL
BEGIN
        DROP TABLE #TMP_FILIAL
END
CREATE TABLE #TMP_FILIAL (CD_BANDEIRA INT, CD_FILIAL INT)
IF @CompraBandeira= 1
BEGIN
        INSERT INTO #TMP_FILIAL
        select 
                B.CD_BANDEIRA,
                F.CD_FILIAL 
        from 
                EST_PROD_AGENDA_COMPRA A
                JOIN EST_PROD_AGENDA_COMPRA_PRC_BANDEIRA B ON
                A.CD_CTR_AGENDA =B.CD_CTR_AGENDA
                JOIN PRC_BANDEIRA_PRC_FILIAL F ON
                B.CD_BANDEIRA = F.CD_BANDEIRA 
        WHERE
                A.CD_CTR_AGENDA = @CD_AGENDA 
                 
        INSERT INTO #TMP_FILIAL
        SELECT 
                BF.CD_BANDEIRA,
                F.CD_FILIAL 
        FROM 
                EST_PROD_AGENDA_COMPRA A
                JOIN EST_PROD_AGENDA_COMPRA_PRC_FILIAL F ON
                A.CD_CTR_AGENDA =F.CD_CTR_AGENDA
        
                JOIN PRC_BANDEIRA_PRC_FILIAL BF ON
                F.CD_FILIAL = BF.CD_FILIAL
                LEFT JOIN #TMP_FILIAL T ON 
                F.CD_FILIAL  = T.CD_FILIAL 
        WHERE
                T.CD_FILIAL IS NULL
                AND        A.CD_CTR_AGENDA = @CD_AGENDA ;
        IF  NOT EXISTS (SELECT TOP 1 1 FROM #TMP_FILIAL ) AND LEN(@CD_FILIAL) >0
        BEGIN
                INSERT INTO #TMP_FILIAL
                SELECT 
                        F.CD_BANDEIRA,
                        F.CD_FILIAL 
                FROM 
                        PRC_BANDEIRA_PRC_FILIAL F
                WHERE 
                        F.CD_EMP =@CD_EMP
                        AND F.CD_FILIAL IN (SELECT  ID FROM UFD_PRM_IN_STRING(@CD_FILIAL)); 
        END
END
ELSE
BEGIN
        
        INSERT INTO #TMP_FILIAL
        SELECT 
                0 CD_BANDEIRA,
                F.CD_FILIAL 
        FROM 
                EST_PROD_AGENDA_COMPRA A
                JOIN EST_PROD_AGENDA_COMPRA_PRC_FILIAL F ON
                A.CD_CTR_AGENDA =F.CD_CTR_AGENDA
        
                LEFT JOIN #TMP_FILIAL T ON 
                F.CD_FILIAL  = T.CD_FILIAL 
        WHERE
                T.CD_FILIAL IS NULL
                AND        A.CD_CTR_AGENDA = @CD_AGENDA ;
        IF  NOT EXISTS (SELECT TOP 1 1 FROM #TMP_FILIAL ) AND LEN(@CD_FILIAL) >0
        BEGIN
                INSERT INTO #TMP_FILIAL
                SELECT 
                        0 CD_BANDEIRA,
                        F.CD_FILIAL 
                FROM 
                        PRC_FILIAL F
                WHERE 
                        F.CD_EMP =@CD_EMP
                        AND F.CD_FILIAL IN (SELECT  ID FROM UFD_PRM_IN_STRING(@CD_FILIAL)); 
        END
END
        delete from #TMP_FILIAL
        where CD_FILIAL IN (SELECT         CD_FILIAL
                                                                        FROM
                                                                                PRC_FILIAL
                                                                        WHERE
                                                                                PRC_FILIAL.FILIAL_MTZ = 1 OR  PRC_FILIAL.FLAG_OPERADOR_LOG = 1);
        delete from #TMP_FILIAL
        where CD_FILIAL IN (SELECT         CD_FILIAL
                                                                        FROM
                                                                                V_PRC_FILIAL_RELACAO_DEPOSITOS);
Print 'Carregou as filiais da agenda - Time ' + convert(varchar, getdate(),108);
IF  NOT EXISTS (SELECT TOP 1 1 FROM #TMP_FILIAL )
BEGIN
        Print 'Nenhuma filial carregada - Time ' + convert(varchar, getdate(),108);
        Return;
END
/***********************************************************************************************/
if @NAO_UTILIZA_AGD_FACE =0
begin
        INSERT INTO #RS_AGD_FACE
        SELECT 
                CD_EMP,
                CD_AGD 
        FROM 
                EST_PROD_CPL_FACE_AGENDA 
        WHERE
                STS_AGD =1 
				 
end
/***********************************************************************************************/
-- Carga dos produtos que participam da agenda.
/***********************************************************************************************/
IF  OBJECT_ID('TEMPDB.DBO.#TMP_PROD') IS NOT NULL
BEGIN
        DROP TABLE #TMP_PROD
END
CREATE TABLE #TMP_PROD (CD_EMP TINYINT,CD_PROD INT,
                                                FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT,
                                                QT_UNI_RESSUPRIMENTO MONEY,
                                                APRES_QT_CP          MONEY );
IF  OBJECT_ID('TEMPDB.DBO.#TMP_PROD_AUX') IS NOT NULL
BEGIN
        DROP TABLE #TMP_PROD_AUX
END
        CREATE TABLE #TMP_PROD_AUX (CD_EMP TINYINT,
                                                                CD_PROD INT);
                                                          
        --Produtos
        if @PED_QTD_DEF =1 
        begin
        
           INSERT INTO #TMP_PROD 
           SELECT 
                  P.CD_EMP,                
                  P.CD_PROD
                  ,0,0,0 
           FROM 
                  EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA p
           WHERE
                  P.CD_EMP = @CD_EMP
                  AND p.CD_USU = @CD_USU;  
        end
        else
        begin
            IF @RELA_CD_PROD = ''
            BEGIN
                    INSERT INTO #TMP_PROD 
                    SELECT 
                            P.CD_EMP,                
                            P.CD_PROD
                                ,0,0,0 
                    FROM 
                            EST_PROD_AGENDA_COMPRA_EST_PROD p
                    WHERE
                            P.CD_EMP = @CD_EMP
                            AND p.CD_CTR_AGENDA = @CD_AGENDA ;  
            END
            ELSE
            BEGIN
                    INSERT INTO #TMP_PROD
                    SELECT 
                            @CD_EMP, 
                            ID 
                                ,0,0,0 
                    FROM UFD_PRM_IN_STRING(@RELA_CD_PROD);
            END 
		end
		
        if exists(select top 1 1 from #TMP_PROD )
                GOTO FimCargaProdutos
                 
        --Fabricantes
        INSERT INTO #TMP_PROD 
        SELECT 
                F.CD_EMP, 
                P.CD_PROD
                ,0,0,0 
        FROM 
                EST_PROD_AGENDA_COMPRA_EST_PROD_FABRIC F
                JOIN EST_PROD P ON 
                F.CD_EMP = P.CD_EMP AND
                F.CD_FABRIC = P.CD_FABRIC
        WHERE
                P.CD_EMP = @CD_EMP
                AND F.CD_CTR_AGENDA = @CD_AGENDA ; 
        
        --select top 5* from #TMP_PROD
        --Linhas
        if exists(select top 1 1 from #TMP_PROD )
        begin                
                INSERT INTO #TMP_PROD_AUX 
                SELECT 
                        L.CD_EMP,
                        A.CD_PROD 
                FROM 
                        EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_LINHA L
                        JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
                        L.CD_EMP = A.CD_EMP AND
                        L.CD_ARV_MERC_LINHA= A.CD_ARV_MERC_LINHA 
                        JOIN #TMP_PROD T ON 
                        A.CD_EMP  = T.CD_EMP AND
                        A.CD_PROD = T.CD_PROD                        
                WHERE
                        L.CD_CTR_AGENDA = @CD_AGENDA ;
                if @@rowcount>0
                begin
                        TRUNCATE TABLE #TMP_PROD 
                        INSERT INTO #TMP_PROD 
                        SELECT CD_EMP, CD_PROD,0,0,0  FROM #TMP_PROD_AUX;
                        TRUNCATE TABLE #TMP_PROD_AUX
                end
        end
        ELSE
        BEGIN
                INSERT INTO #TMP_PROD
                SELECT 
                        L.CD_EMP,
                        A.CD_PROD 
                        ,0,0,0 
                FROM 
                        EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_LINHA L
                        JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
                        L.CD_EMP = A.CD_EMP AND
                        L.CD_ARV_MERC_LINHA= A.CD_ARV_MERC_LINHA  
                WHERE
                        L.CD_CTR_AGENDA = @CD_AGENDA ;
        END
         
        --Categorias 
        if exists(select top 1 1 from #TMP_PROD )
        begin                
                INSERT INTO #TMP_PROD_AUX 
                SELECT 
                        C.CD_EMP,                
                        A.CD_PROD                         
                FROM 
                        EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_CATEGORIA C
                        JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
                        C.CD_EMP = A.CD_EMP AND
                        C.CD_ARV_MERC_CATEG= A.CD_ARV_MERC_CATEG 
                        JOIN #TMP_PROD T ON 
                        A.CD_EMP  = T.CD_EMP AND
                        A.CD_PROD = T.CD_PROD        
                WHERE
                        A.CD_EMP = @CD_EMP
                        AND C.CD_CTR_AGENDA = @CD_AGENDA ;  
                        
                if @@rowcount>0
                begin
                        TRUNCATE TABLE #TMP_PROD 
                        INSERT INTO #TMP_PROD 
                        SELECT 
                                CD_EMP, CD_PROD 
                                ,0,0,0 
                        FROM #TMP_PROD_AUX;
                        TRUNCATE TABLE #TMP_PROD_AUX
                end
        END
        ELSE
        BEGIN
                INSERT INTO #TMP_PROD 
                SELECT 
                        C.CD_EMP,                
                        A.CD_PROD
                        ,0,0,0 
                FROM 
                        EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_CATEGORIA C
                        JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
                        C.CD_EMP = A.CD_EMP AND
                        C.CD_ARV_MERC_CATEG= A.CD_ARV_MERC_CATEG 
                WHERE
                        A.CD_EMP = @CD_EMP
                        AND C.CD_CTR_AGENDA = @CD_AGENDA ; 
        END
        
        update p
          set
                FLAG_RESSUPRIMENTO_CAIXA_FECHADA = pO.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
                QT_UNI_RESSUPRIMENTO                         = pO.QT_UNI_RESSUPRIMENTO, 
                APRES_QT_CP                                                 = pO.APRES_QT_CP
          FROM
                #TMP_PROD p
                JOIN EST_PROD pO ON 
                P.CD_EMP  = pO.CD_EMP AND
                P.CD_PROD = pO.CD_PROD;
/***********************************************************************************************/
        --select top 5* from #TMP_PROD
FimCargaProdutos:
        /***********************************************************************************************/
        IF @FLAG_NAO_ENVIAR_PBM > 0
        BEGIN
                DELETE P
                FROM #TMP_PROD P
                INNER JOIN ( SELECT DISTINCT CD_EMP, CD_PROD FROM EST_PROD_RC_CLI_CONV PC
                                        WHERE PC.CD_EMP = 1 AND PC.REPOSICAO = 'S') M ON
                                        P.CD_EMP  = M.CD_EMP AND
                                        P.CD_PROD = M.CD_PROD
        END
        
         
        /***********************************************************************************************/
         
        Print 'Carregou produtos da agenda - Time ' + convert(varchar, getdate(),108);
        IF  OBJECT_ID('TEMPDB.DBO.#TMP_PROD_AUX') IS NOT NULL
        BEGIN
                DROP TABLE #TMP_PROD_AUX
        END
        
        IF  NOT EXISTS (SELECT TOP 1 1 FROM #TMP_PROD )
        BEGIN
                Print 'Nenhum produto carregado - Time ' + convert(varchar, getdate(),108);
                Return;
        END
        
        CREATE NONCLUSTERED INDEX IX_#TMP_PROD_CD_EMP_CD_PROD
                ON [dbo].[#TMP_PROD] ([CD_EMP],[CD_PROD])
        CREATE NONCLUSTERED INDEX IX_#TMP_PROD_CD_PROD
                ON [dbo].[#TMP_PROD] ([CD_PROD])
                INCLUDE ([FLAG_RESSUPRIMENTO_CAIXA_FECHADA],[QT_UNI_RESSUPRIMENTO])
/***********************************************************************************************/
 
/***********************************************************************************************/
-- Monta as listas de preco
/***********************************************************************************************/
--Listas de preco
INSERT INTO #RS_LISTA_PRECO  (CD_COND_COMPRA,CD_PROD,VLR_PROD, PERC_DESC)
SELECT
        L.CD_COND_COMPRA, 
        L.CD_PROD, 
        L.VLR_PROD, 
        L.PERC_DESC 
FROM 
        EST_PROD_PRECO_COND_COMPRA_CPL  L
        INNER JOIN #TMP_PROD P ON 
        L.CD_EMP        = P.CD_EMP AND
        L.CD_PROD        = P.CD_PROD 
WHERE
        L.CD_EMP=@CD_EMP
        AND L.CD_COND_COMPRA IN  (SELECT ID  FROM UFD_PRM_IN_STRING(@LISTA_PRECO));   
--Tratando produtos em mais de uma lista de precos
WHILE EXISTS(SELECT        
                                CD_PROD 
                        FROM 
                                #RS_LISTA_PRECO 
                        GROUP BY CD_PROD HAVING COUNT(CD_COND_COMPRA)> 1)
BEGIN
        DELETE FROM L 
        FROM 
        #RS_LISTA_PRECO L
        INNER JOIN (SELECT DISTINCT
                                        R.CD_PROD,
                                        D.CD_COND_COMPRA
                                FROM
                                        #RS_LISTA_PRECO R
                                        CROSS APPLY (SELECT TOP 1
                                                                        P.CD_COND_COMPRA,
                                                                        P.CD_PROD,
                                                                        P.VLR_PROD * (1-(P.PERC_DESC/100.00)) VLR_PROD
                                                                FROM 
                                                                         #RS_LISTA_PRECO P  
                                                                WHERE P.CD_PROD  = R.CD_PROD
                                                                ORDER BY VLR_PROD DESC ) D ) D ON
                L.CD_PROD                  = D.CD_PROD AND
                L.CD_COND_COMPRA  = D.CD_COND_COMPRA  
END
  
   
/***********************************************************************************************/
-- Monta vinculo de produtos filial
/***********************************************************************************************/
IF  OBJECT_ID('TEMPDB.DBO.#TMP_PROD_CPL') IS NOT NULL
BEGIN
        DROP TABLE #TMP_PROD_CPL
END
        CREATE TABLE #TMP_PROD_CPL (CD_EMP TINYINT, CD_FILIAL INT, CD_BANDEIRA INT, CD_PROD INT)
        
		IF @PED_QTD_DEF = 2
			BEGIN
				INSERT INTO #TMP_PROD_CPL
				SELECT
						@CD_EMP AS CD_EMP, 
						A.CD_FILIAL, 
						B.CD_BANDEIRA,
						A.CD_PROD
				FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA_POR_FILIAL A
				INNER JOIN #TMP_FILIAL B ON A.CD_FILIAL = B.CD_FILIAL
				WHERE A.CD_USU = @CD_USU
				
			END
		ELSE
			BEGIN
				INSERT INTO #TMP_PROD_CPL
				SELECT 
						A.CD_EMP, 
						B.CD_FILIAL, 
						B.CD_BANDEIRA,
						A.CD_PROD
				FROM 
						#TMP_PROD A, #TMP_FILIAL B 
			END
         
IF  OBJECT_ID('TEMPDB.DBO.#TMP_FILIAL') IS NOT NULL
BEGIN
        DROP TABLE #TMP_FILIAL
END
        CREATE UNIQUE CLUSTERED INDEX #ix_TMP_PROD_CPL ON #TMP_PROD_CPL (CD_PROD,CD_FILIAL,CD_EMP);                
  
        CREATE UNIQUE NONCLUSTERED INDEX #ix_TMP_PROD_CPL_BANDEIRA ON #TMP_PROD_CPL (CD_PROD,CD_FILIAL,CD_BANDEIRA,CD_EMP);                
  
IF @CompraBandeira= 1
BEGIN
        --Realiza o vinculo do status do produto por bandeira
        -- Deleta todos q estao inativos ou bloqueados na bandeira (1 ou 2)
        DELETE from C
        FROM
                #TMP_PROD_CPL C
                JOIN EST_PROD_PRC_BANDEIRA b ON 
                C.CD_EMP  = B.CD_EMP AND
                C.CD_BANDEIRA  = B.CD_BANDEIRA AND
                C.CD_PROD = B.CD_PROD
        WHERE
                B.STS_PROD <> 0
                and b.cd_emp=@cd_emp;
        --Realiza o vinculo do tipo de compra por bandeira
        IF @TIPO_COMPRA<> ''
        BEGIN
                
        --        --CREATE TABLE TIPO_COMPRA (TIPO VARCHAR(100))
        --        INSERT INTO TIPO_COMPRA SELECT @TIPO_COMPRA;
                DELETE T
                FROM
                        #TMP_PROD_CPL T
                        LEFT JOIN (
                                                SELECT
                                                        P.CD_EMP,
                                                        b.CD_BANDEIRA,
                                                        P.CD_PROD 
                                                FROM 
                                                        EST_PROD p
                                                        LEFT JOIN EST_PROD_PRC_BANDEIRA b ON 
                                                        P.CD_EMP  = B.CD_EMP AND
                                                        P.CD_PROD = B.CD_PROD
                                                WHERE
                                                        P.CD_EMP =@CD_EMP
                                                        AND  ISNULL(B.COMPRA_POR_SUPRIMENTO,P.COMPRA_POR_SUPRIMENTO) IN(SELECT ID FROM 
                                                                                                                                                                                                UFD_PRM_IN_STRING(@TIPO_COMPRA))
                                                ) V ON 
                        T.CD_EMP        = V.CD_EMP AND 
                        T.CD_BANDEIRA = V.CD_BANDEIRA AND 
                        T.CD_PROD = V.CD_PROD
                WHERE
                        V.CD_EMP IS NULL
                        
        END
        --Realiza o vinculo do tipo de compra por bandeira
        IF @TIPO_VAN_COMPRA <> ''
        BEGIN
                DELETE T
                FROM
                        #TMP_PROD_CPL T
                        LEFT JOIN (SELECT
                                                        P.CD_EMP,
                                                        b.CD_BANDEIRA,
                                                        P.CD_PROD
                                                FROM 
                                                        EST_PROD p
                                                        LEFT JOIN EST_PROD_PRC_BANDEIRA b ON 
                                                        P.CD_EMP  = B.CD_EMP AND
                                                        P.CD_PROD = B.CD_PROD
                                                WHERE
                                                        P.CD_EMP =@CD_EMP
                                                        AND ISNULL(B.TP_VAN_COMPRA, P.FLAG_COMPRA_PHARMALINK)IN( SELECT ID FROM 
                                                                                                                                                                                UFD_PRM_IN_STRING(@TIPO_VAN_COMPRA))
                                                ) V ON 
                        T.CD_EMP                = V.CD_EMP AND 
                        T.CD_BANDEIRA        = V.CD_BANDEIRA AND 
                        T.CD_PROD                = V.CD_PROD
                WHERE
                        V.CD_EMP IS NULL 
        END
end
else --Analisa por filial
begin
        set @SqlTxt = 'DELETE from C
                                        FROM
                                                #TMP_PROD_CPL C
                                                JOIN EST_PROD_CPL  b ON 
                                                C.CD_EMP        = B.CD_EMP AND
                                                C.CD_FILIAL        = B.CD_FILIAL AND
                                                C.CD_PROD        = B.CD_PROD
                                        WHERE
                                                B.STS_PROD <> 0
                                                and b.CD_EMP=1';
        exec (@SqlTxt);
        set @SqlTxt = 'DELETE from C
                                        FROM
                                                #TMP_PROD_CPL C
                                                JOIN EST_PROD b ON 
                                                C.CD_EMP        = B.CD_EMP AND
                                                C.CD_PROD        = B.CD_PROD
                                        WHERE
                                                B.STS_PROD <> 0
                                                and b.CD_EMP=1'; 
        exec (@SqlTxt);
    if @CD_DEPO_ENTREGA > 0 
    begin
           --Respeita o status no cd de entrega
                    
                set @SqlTxt = 'DELETE from C
           FROM
                  #TMP_PROD_CPL C
                  JOIN EST_PROD_CPL  b ON 
                  C.CD_EMP        = B.CD_EMP AND
                  C.CD_PROD        = B.CD_PROD
           WHERE
                  B.STS_PROD <> 0
                  and b.CD_FILIAL = ' + convert(varchar, @CD_DEPO_ENTREGA) +  'and b.CD_EMP= 1;'
                  exec (@SqlTxt);
    end
                 
        IF @TIPO_COMPRA<> ''
        BEGIN
                print 'Tipo de compra ' + @TIPO_COMPRA 
                 
                set @SqlTxt = 'DELETE T        FROM
                        #TMP_PROD_CPL T
                        join EST_PROD p on 
                        T.CD_EMP  = p.CD_EMP AND 
                        T.CD_PROD = p.CD_PROD
                WHERE
                        P.CD_EMP =' + convert(varchar(2), @CD_EMP) + ' AND not P.COMPRA_POR_SUPRIMENTO IN (' +@TIPO_COMPRA +')'
                exec (@SqlTxt);
        END
        --Realiza o vinculo do tipo de compra por bandeira
        IF @TIPO_VAN_COMPRA <> ''
        BEGIN
                DELETE T
                FROM
                        #TMP_PROD_CPL T
                        join EST_PROD p on 
                        T.CD_EMP  = p.CD_EMP AND 
                        T.CD_PROD = p.CD_PROD
                WHERE
                        P.CD_EMP =@CD_EMP
                        AND NOT P.FLAG_COMPRA_PHARMALINK IN (SELECT ID FROM UFD_PRM_IN_STRING(@TIPO_VAN_COMPRA))
        END
end
         
Print 'Carregou produtos e filiais da agenda - Time ' + convert(varchar, getdate(),108);
 
/***********************************************************************************************/
-- Monta os depositos da agenda
/***********************************************************************************************/
 
IF  OBJECT_ID('TEMPDB.DBO.#TMP_DEPO') IS NOT NULL
BEGIN
        DROP TABLE #TMP_DEPO
END
        CREATE TABLE #TMP_DEPO (CD_EMP TINYINT, CD_FILIAL_DEPO INT)
        SET @CONSIDERA_EST_CD =0;
        INSERT INTO #TMP_DEPO
        SELECT 
                @CD_EMP, 
                ID 
        FROM UFD_PRM_IN_STRING(@CD_DEPOSITOS);
        IF EXISTS (SELECT * FROM #TMP_DEPO WHERE CD_FILIAL_DEPO> 0 )
        BEGIN
                SET @CONSIDERA_EST_CD =1
        END
        if @CD_DEPO_ENTREGA > 0
        begin
                set @CONSIDERA_EST_CD=1;                        
                TRUNCATE TABLE #TMP_DEPO;
                INSERT INTO #TMP_DEPO
                SELECT 
                        @CD_EMP, @CD_DEPO_ENTREGA        
        end 
/***********************************************************************************************/
-- Testes
/***********************************************************************************************/
 --select * From #TMP_PROD 
 --select * From #TMP_FILIAL
 --SELECT TOP 20 * FROM #TMP_PROD_CPL
 --SELECT * FROM #TMP_DEPO
 --SELECT * FROM EST_PROD_AGENDA_COMPRA
 --SELECT @PAR_EST_AA,@PAR_EST_A,@PAR_EST_B,@PAR_EST_C , @PAR_EST_D
 --SELECT * FROM #RS_SIGLA
/***********************************************************************************************/
/*******************   CALCULA A NECESSIDADE DAS LOJAS        ****************************************/
/***********************************************************************************************/
         
                
print 'Calculando a necessidade das lojas ' + convert(varchar(10),getdate(),108);
IF  OBJECT_ID('TEMPDB.DBO.#TMP_DEMANDA') IS NOT NULL
BEGIN
        DROP TABLE #TMP_DEMANDA
END
CREATE TABLE #TMP_DEMANDA(CD_EMP                tinyint,
                                                                CD_FILIAL        int,
                                                                CD_PROD                int,
                                                                ESEG                money,
                                                                EMAX                        money,
                                                                ESEG_d                        money,
                                                                EMAX_d                        money,
                                                                QTDE_LIMITADOR        money,
                                                                MAX_EMAX                money,
                                                                QT_EST                        money,
                                                                NECESSIDADE                money,
                                                                NECESSIDADE_INI        money,
                                                                SUGESTAO                money,
                                                                CD_USU                        int,
                                                                CD_COND_COMPRA        int,
                                                                VLR_PROD                money,
                                                                PERC_DESC                money,
                                                                CD_SIGLA                tinyint,
                                                                MEDIAF                        money,
                                                                QT_EST_PEND                money,
                                                                QT_EST_MTZ                money,
                                                                FACE                        money,
                                                                FINA                        money,
                                                                LIMITADOR                money,
                                                                QT_PEND_ENT                money,
                                                                VLR_TABELA                money, 
                                                                QTDE_NECESSIDADE        money,
                                                                QTDE_TOT                money,
                                                                QT_EST_REAL                money,
                                                                QT_EST_CD_DISP         money,
                                                                QT_PEND_ENT_DEP money,
                                                                QT_EST_DEPOSITO money,
                                                                QT_PEND_SAI money)


----------------------------------------------------------------------------------------------------------------------



	if @NAO_UTILIZA_AGD_FACE =0
	begin

		INSERT INTO #RS_AGD_FACE_PROD(CD_EMP, CD_FILIAL, CD_PROD, QTDE_FACE)
		SELECT
			A.CD_EMP,
			A.CD_FILIAL,
			A.CD_PROD,
			A.QTDE_FACEAMENTO 
		FROM 
			(SELECT
				A_.CD_EMP,
				A_.CD_PROD,
				A_.CD_FILIAL,
				MAX(A_.CD_AGD) AS CD_AGD
			FROM 
				EST_PROD_CPL_FACE_AGENDA_EST_PROD A_
				JOIN #TMP_PROD_CPL e on 
					A_.CD_FILIAL = E.CD_FILIAL AND      
					A_.CD_PROD   = E.CD_PROD
				INNER JOIN #RS_AGD_FACE F_ ON
					F_.CD_EMP    = A_.CD_EMP AND  
					F_.CD_AGD    = A_.CD_AGD 
			GROUP BY 
				A_.CD_EMP,
				A_.CD_PROD,
				A_.CD_FILIAL) AGD_PROD_1

				INNER JOIN EST_PROD_CPL_FACE_AGENDA_EST_PROD A ON 
				A.CD_EMP	= AGD_PROD_1.CD_EMP AND
				A.CD_PROD	= AGD_PROD_1.CD_PROD AND
				A.CD_FILIAL = AGD_PROD_1.CD_FILIAL AND
				A.CD_AGD	= AGD_PROD_1.CD_AGD 
		WHERE 
			A.VALID_QTDE_FACEAMENTO > getdate() -1;


	end


    INSERT INTO #TMP_DEMANDA
    SELECT      
            E.CD_EMP,    
            E.CD_FILIAL,   
            E.CD_PROD,   
                
            ROUND(dbo.UFD_EST_AJUSTA_Eseg(			CASE WHEN @CONSIDERA_FACE = 0 THEN 0 ELSE
														CASE WHEN ISNULL(e.PERC_ESEG_FACEAMENTO,0)=0 THEN 
															ISNULL(AGD_PROD.QTDE_FACE, E.QTDE_FACEAMENTO)
														ELSE 
															ROUND(ISNULL(AGD_PROD.QTDE_FACE, E.QTDE_FACEAMENTO)* (ISNULL(e.PERC_ESEG_FACEAMENTO,0)/100.00),0)
														END
													END, 
                                                    e.VALID_QTDE_FACEAMENTO,-- VALID_QTDE_FACEAMENTO 
                                                    e.QTDE_FINANCIADO,
                                                    ROUND(((E.MEDIAF / 30.0000) * (E.ESEG)),0)                                                         
                                                    ),0)            ESEG,
                                                                         
            ROUND(((E.MEDIAF / 30.0000) * (E.EMAX)),0) EMAX, 
            E.ESEG,  
            E.EMAX, 
            E.QTDE_LIMITADOR,
            0 AS MAX_EMAX,          
            ISNULL(E.QT_EST_PEND,0) QT_EST,
            0 AS NECESSIDADE,
            0 NECESSIDADE_INI,
            ROUND((E.MEDIAF / 30.0000) * (CASE 
                                                                            WHEN E.CD_SIGLA = 5 THEN @PAR_EST_AA
                                                                            WHEN E.CD_SIGLA = 1 THEN @PAR_EST_A
                                                                            WHEN E.CD_SIGLA = 2 THEN @PAR_EST_B
                                                                            WHEN E.CD_SIGLA = 3 THEN @PAR_EST_C
                                                                            WHEN E.CD_SIGLA = 4 THEN @PAR_EST_D
                                                                    END),0)   SUGESTAO,
            @CD_USU CD_USU,
            ISNULL(LST.CD_COND_COMPRA,0) CD_COND_COMPRA,
            coalesce(LST.VLR_PROD, EST_PROD.VLR_FABRICA,0)        VLR_PROD,
            ISNULL(LST.PERC_DESC ,0) PERC_DESC ,
            E.CD_SIGLA,
            E.MEDIAF, 
            E.QT_EST_PEND,
            0 QT_EST_MTZ,  
            ISNULL(AGD_PROD.QTDE_FACE, E.QTDE_FACEAMENTO)   FACE,
            E.QTDE_FINANCIADO FINA,
            E.QTDE_LIMITADOR  LIMITADOR,
            E.QT_PEND_ENT, 
            isnull(SS.VLR_TABELA,0) VLR_TABELA,
            0 QTDE_NECESSIDADE,
            0 QTDE_TOT,
            (E.QT_EST +  isnull(E.QT_EST_EM_TERC,0))  QT_EST_REAL,
            0 QT_EST_CD_DISP,
            0 QT_PEND_ENT_DEP,
            0 QT_EST_DEPOSITO,
            E.QT_PEND_SAI
    FROM  
            V_EST_PROD_CPL_ESTOQUE_PEDIDO E
            INNER JOIN EST_PROD    ON    
            E.CD_EMP        = EST_PROD.CD_EMP AND    
            E.CD_PROD        = EST_PROD.CD_PROD  
            INNER JOIN #TMP_PROD_CPL cp  ON    
            E.CD_EMP        = cp.CD_EMP AND    
            E.CD_FILIAL        = cp.CD_FILIAL AND    
            E.CD_PROD        = cp.CD_PROD   
            LEFT JOIN EST_PROD_PRECO  SS ON    
            E.CD_EMP        = SS.CD_EMP AND    
            E.CD_FILIAL        = SS.CD_FILIAL AND 
            E.CD_PROD        = SS.CD_PROD  
                 
            INNER JOIN #RS_SIGLA S ON    
            E.CD_SIGLA        = S.CD_SIGLA   
            LEFT JOIN #RS_LISTA_PRECO LST ON  
            EST_PROD.CD_PROD    = LST.CD_PROD 
			
			LEFT JOIN #RS_AGD_FACE_PROD AGD_PROD ON 
			E.CD_EMP        = AGD_PROD.CD_EMP AND    
            E.CD_FILIAL     = AGD_PROD.CD_FILIAL AND 
            E.CD_PROD       = AGD_PROD.CD_PROD  
    WHERE  
            E.CD_EMP = @CD_EMP         
            AND E.STS_PROD =0   
            ANd E.STS_PROD_FILIAL =0;
                
	if @PED_QTD_DEF =0 AND @EXIBIR_PRODUTOS_SEM_DEMANDA = 0
	begin
		delete from  #TMP_DEMANDA
		where 
			(MEDIAF+ FACE+ FINA + LIMITADOR )< 0.01
			and  QT_EST =0; 
	end


/************************************************************************************************************************/
--Preco do produto
/************************************************************************************************************************/


		print 'Atualiza o preco do produto a necessidade das lojas ' + convert(varchar(10),getdate(),108);
		CREATE NONCLUSTERED INDEX #ix_#TMP_DEMANDA_VLR_PROD ON #TMP_DEMANDA (VLR_PROD);    

		--Atualiza o preco do produto        
		update #TMP_DEMANDA
		set
		        VLR_PROD = dbo.UFD_EST_PROD_PRECO_TBL(@CD_EMP,CD_FILIAL,CD_PROD,1)
		where
		        VLR_PROD =0;
				
		--Coloca 1 centavo para precos zerado. solicitaco Quintella
		update A
			SET A.VLR_PROD = CASE WHEN B.VLR_PROD = 0 THEN 0.01 
								ELSE B.VLR_PROD END
		FROM 
			#TMP_DEMANDA A
			INNER JOIN(SELECT  E.CD_PROD,
								ROUND(AVG(E.VLR_PROD), 2) AS VLR_PROD
							FROM #TMP_DEMANDA E
					GROUP BY E.CD_PROD
			) B ON A.CD_PROD = B.CD_PROD
				
				
        --Coloca 1 centavo para precos zerado. solicitaco Quintella
        /*update 
                #TMP_DEMANDA
        set VLR_PROD = 0.01
        where
                ISNULL(VLR_PROD,0) =0;*/
/************************************************************************************************************************/
--  PARAMETRO ESPECIAL
----ANALIZANDO SE O PARAMETRO DE MEDIA F POSSUI ALGUM PARAMETRO ESPECIAL
           UPDATE  P
           SET 
                  EMAX                     =    ROUND((p.MEDIAF / 30.0000) * (P.EMAX_D + ((P.EMAX_D *  pesp.EMAX)/100.0000)),0),
                  ESEG                     =    ROUND((p.MEDIAF / 30.0000) *  (P.ESEG_D + ((P.ESEG_D *  pesp.ESEG)/100.0000)),0)
           FROM         
                  #TMP_DEMANDA P
                  JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA arv ON 
                  P.CD_EMP = ARV.CD_EMP AND
                  P.CD_PROD = ARV.CD_PROD AND
                  P.CD_FILIAL = ARV.CD_FILIAL
                  
                  INNER JOIN  EST_ARV_MD_F_GRP_PARAM_ESPECIAIS PESP  ON
                  PESP.CD_EMP           = arv.CD_EMP AND
                  PESP.CD_GRP_PARAM     = arv.CD_GRP_PARAM
           WHERE
                  ARV.CD_EMP=@CD_EMP
                  AND (PESP.FDIAS_ULT_ATU IS NULL
                                OR PESP.FDIAS_ULT_ATU <= DATEADD(DAY,- PESP.FDIAS, convert(date, getdate())))
                  AND (DATEDIFF (DAY, PESP.DT_INICIAL , convert(date, getdate())) % PESP.FDIAS) = 0
                  AND PESP.DT_INICIAL <=convert(date, getdate());
         
           ----Gerando aumento de percentual do emax e eseg por data
           UPDATE P
           SET 
                  EMAX                     =     ROUND(P.EMAX + ((P.EMAX *  AUMENT.PERC_AUMENTO)/100.0000),0),
                  ESEG                     =     ROUND(P.ESEG + ((P.ESEG *  AUMENT.PERC_AUMENTO)/100.0000),0)
           FROM         
                  EST_ARV_GRP_RESSUPRIMENTO_PERC_AUMENTO AUMENT     
                  INNER JOIN #TMP_DEMANDA P ON
                  AUMENT.CD_EMP = P.CD_EMP AND
                  AUMENT.CD_SIGLA = P.CD_SIGLA
           WHERE
                  AUMENT.DT_RESSUP = convert(date, getdate())
        
        IF @TIPO_AGENDA=3 --Eletronico
        BEGIN
           ----Analizando se o parametro de media f possui algum parametro especial por dia da semana
           UPDATE P 
           SET  
                  EMAX                     =     ROUND(((p.MEDIAF / 30.0000) * (pesp.EMAX)),0) ,
                  ESEG                     =     ROUND(((p.MEDIAF / 30.0000) * (pesp.ESEG)),0)  
           FROM         
                  #TMP_DEMANDA P
                  JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA arv ON 
                  P.CD_EMP = ARV.CD_EMP AND
                  P.CD_PROD = ARV.CD_PROD AND
                  P.CD_FILIAL = ARV.CD_FILIAL
                  
                  INNER JOIN  EST_ARV_MD_F_GRP_PARAM_ESPECIAIS_DIA_SEMANA PESP  ON
                  PESP.CD_EMP           = arv.CD_EMP AND
                  PESP.CD_GRP_PARAM     = arv.CD_GRP_PARAM
                   
           WHERE
                  PESP.DIA_SEMANA = DATEPART(WEEKDAY, getdate())
                  AND PESP.FLAG_APLICACAO IN (0,2);
    END
                
/*********************************************************************************************************************************/
        --Carrega o QMAX
        Declare @data DATETIME;
                set @data=CONVERT(CHAR(10),GETDATE(),112);
        update #TMP_DEMANDA
        set max_emax= ROUND(dbo.UFD_EST_AJUSTA_EMAX(CASE WHEN @CONSIDERA_FACE = 0 THEN 0  
                                                                                  ELSE FACE END, 
                                                                                  @data, 
                                                                                  FINA,        
                                                                                  LIMITADOR, 
                                                                                  EMAX),0);
        CREATE UNIQUE CLUSTERED INDEX #ix_#TMP_DEMANDA ON #TMP_DEMANDA (CD_PROD,CD_FILIAL,CD_EMP);                
        print 'Criou a demanda ' + convert(varchar(10),getdate(),108);
/************************************************************************************************************************/        
 --necessidade inicial        
/**********************************************************************************************************************/
        -- Zera o estoque em caso de negativo         
        UPDATE D SET QT_EST = 0 FROM  #TMP_DEMANDA D
        WHERE         
                QT_EST < 0;
         /***********************************************************************************/
        --Coloca a necessidade inicial         
        /***********************************************************************************/
        if @CD_DEPO_ENTREGA =0 --Direto Loja
        begin
                UPDATE D
                SET
                        NECESSIDADE_INI = MAX_EMAX,                        
                        NECESSIDADE                = 	CASE WHEN @CONSIDERA_ESEG = 1 THEN
															CASE WHEN QT_EST <= ESEG THEN MAX_EMAX - QT_EST 
															ELSE 
																CASE WHEN QT_EST > MAX_EMAX THEN MAX_EMAX - QT_EST
																ELSE
																	0
																END
															END
															
														ELSE
															MAX_EMAX - QT_EST
														END
                FROM 
                        #TMP_DEMANDA D ; 
						
                /*UPDATE D
                SET
                        NECESSIDADE = MAX_EMAX - QT_EST
                FROM 
                        #TMP_DEMANDA D
                WHERE         
                        ESEG=0
                        AND QT_EST < MAX_EMAX;*/
        end 
        else
        begin
                UPDATE D
                SET
                        NECESSIDADE_INI = MAX_EMAX,
                        SUGESTAO                = ROUND(((MEDIAF/30.00) * (CASE WHEN D.CD_SIGLA = 5 THEN @PAR_EST_AA
                                                                                                                                        WHEN D.CD_SIGLA = 1 THEN @PAR_EST_A
                                                                                                                                        WHEN D.CD_SIGLA = 2 THEN @PAR_EST_B
                                                                                                                                        WHEN D.CD_SIGLA = 3 THEN @PAR_EST_C
                                                                                                                                        WHEN D.CD_SIGLA = 4 THEN @PAR_EST_D END)),03),
                
                        NECESSIDADE                = dbo.UFD_RET_QTDE_PED_INTEGRADO(CASE WHEN @CONSIDERA_FACE = 0 THEN 0 ELSE FACE END                -- @QT_FACEAMENTO
                                                                                                                        , FINA                        -- @QT_FINANCIAMENTO
                                                                                                                        , LIMITADOR                -- @QT_LIMITADOR
                                                                                                                        , EMAX_D                        -- @EMAX
                                                                                                                        , ESEG_D                        -- @ESEG 
                                                                                                                        , (CASE WHEN D.CD_SIGLA = 5 THEN @PAR_EST_AA
                                                                                                                                        WHEN D.CD_SIGLA = 1 THEN @PAR_EST_A
                                                                                                                                        WHEN D.CD_SIGLA = 2 THEN @PAR_EST_B
                                                                                                                                        WHEN D.CD_SIGLA = 3 THEN @PAR_EST_C
                                                                                                                                        WHEN D.CD_SIGLA = 4 THEN @PAR_EST_D END) -- @PARAM
                                                                                                                        ,MEDIAF -- @MEDIAF
                                                                                                                        ,QT_EST -- @QT_EST
                                                                                                                        ,@IGNORAR_EXCESSO -- @TIPO
                                                                                                                        )
                FROM 
                        #TMP_DEMANDA D ;   
        end 
        
/**********************************************************************************************************************/
-- Gravando informações do estoques dos produtos da demanda nos CDs selecionado
/**********************************************************************************************************************/
        IF @CONSIDERA_EST_CD=1  
        BEGIN
                        ;WITH DEPOSITOS_ AS (SELECT
                                                                        L.CD_PROD,
                                                                        SUM(L.QT_EST) QT_EST,
                                                                        SUM(L.QT_PEND_ENT) QT_PEND_ENT
                                                                        FROM
                                                                                V_EST_PROD_CPL_ESTOQUE_PEDIDO L
                                                                                JOIN #TMP_DEPO D ON L.CD_FILIAL = D.CD_FILIAL_DEPO                                                                
                                                                                INNER JOIN #TMP_PROD  P ON 
                                                                                L.CD_EMP = P.CD_EMP AND
                                                                                L.CD_PROD = P.CD_PROD 
                                                                        WHERE        
                                                                                L.CD_EMP=@CD_EMP                                                                 
                                                                        GROUP BY
                                                                                L.CD_PROD
                                                                )
                                                                
                        UPDATE D
                        SET
                                QT_PEND_ENT_DEP = DEP.QT_PEND_ENT,
                                QT_EST_DEPOSITO = DEP.QT_EST
                                
                        FROM #TMP_DEMANDA D
                        INNER JOIN DEPOSITOS_ DEP ON DEP.CD_PROD = D.CD_PROD
        END
/**********************************************************************************************************************/
-- Gerando o estoque da matriz... 
/**********************************************************************************************************************/
         
        IF @CONSIDERA_EST_CD=1  
        BEGIN
                Print 'Geracao do picking do estoque do CD - Time ' +convert(varchar,getdate(),108);
        
                Print 'Considera estoque do CD - Time ' +convert(varchar,getdate(),108);
                INSERT INTO   #RS_AUXRAT (CD_FILIAL,
                                                                                CD_PROD,
                                                                                EMAX,
                                                                                QMIN,
                                                                                QTDE_MEDIAF,
                                                                                QT_EST,
                                                                                QTDE_RESSUP, 
                                                                                MEDIAF,
                                                                                FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
                                                                                QT_UNI_RESSUPRIMENTO,
                                                                                FLAG_RATEIO,
                                                                                QT_EST_CD_DISP,
                                                                                QT_NECESSIDADE,
                                                                                QT_EST_MTZ)        
                        SELECT 
                                        F.CD_FILIAL,
                                        F.CD_PROD,
                                        F.EMAX,
                                        F.ESEG QMIN,
                                        F.MEDIAF QTDE_MEDIAF,
                                        F.QT_EST_PEND QT_EST,
                                        (case when @CD_DEPO_ENTREGA > 0 then 0 
                                                else ISNULL(F.NECESSIDADE,0)  end ) + ceiling(ISNULL(F.SUGESTAO,0))                  QTDE_RESSUP,  
                                        F.MEDIAF,
                                        P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
                                        P.QT_UNI_RESSUPRIMENTO,
                                        0 FLAG_RATEIO,
                                        (case when @CD_DEPO_ENTREGA > 0 then 0 
                                                else ISNULL(F.NECESSIDADE,0)  end ) + ceiling(ISNULL(F.SUGESTAO,0))        QT_EST_CD_DISP,  
                                        F.NECESSIDADE,
                                        QT_DEPOSITO_INICIO QT_EST_MTZ
                                FROM
                                        #TMP_DEMANDA F
                                        INNER JOIN #TMP_PROD P ON 
                                        F.CD_PROD = P.CD_PROD
                        
                                        JOIN (SELECT p.CD_EMP,
                                                                p.CD_PROD,
                                                                --SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) AS QT_DEPOSITO_INICIO
                                                                SUM(P.QT_EST_PEND) AS QT_DEPOSITO_INICIO
                                                        FROM 
                                                                V_EST_PROD_CPL_ESTOQUE_PEDIDO P
                                                                JOIN #TMP_DEPO d on 
                                                                p.CD_FILIAL = d.CD_FILIAL_DEPO
                                                        WHERE 
                                                                P.CD_EMP = @CD_EMP                                                 
                                                        GROUP BY 
                                                                P.CD_EMP, 
                                                                P.CD_PROD
                                                        HAVING SUM(P.QT_EST_PEND) > 0 ) d on 
                                        F.CD_PROD = d.CD_PROD ; 
 
                UPDATE #RS_AUXRAT SET QTDE_RESSUP =0 WHERE QTDE_RESSUP<1; 
                ;WITH FILIAIS AS (SELECT        
                                                        CD_PROD,
                                                        QT_UNI_RESSUPRIMENTO, 
                                                        FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
                                                        QT_EST_FILIAIS_SOMA                = SUM(r.QT_EST),
                                                        QT_MEDIAF_SOMA                        = SUM(r.QTDE_MEDIAF),
                                                        QT_RESSUP_SOMA                        = SUM(ROUND(r.QTDE_RESSUP, 0)),
                                                        QT_NECESSIDADE_FILIAIS        = SUM(ROUND(r.QTDE_RESSUP, 0))
                                                FROM 
                                                        #RS_AUXRAT r
                                                        LEFT JOIN EST_RESSUP_NAO_CONSIDERA_EST_CD_PRC_FILIAL F ON  
                                                        R.CD_FILIAL = F.CD_FILIAL AND 
                                                        F.FLAG_HABILITADO =1
                                                WHERE
                                                        F.CD_FILIAL IS NULL
                                                GROUP BY 
                                                        r.CD_PROD, 
                                                        r.QT_UNI_RESSUPRIMENTO,
                                                        r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA),
                        DEPOSITO AS (SELECT
                                                                l.CD_PROD,
                                                                SUM(L.QT_EST_PEND) QT_DEPOSITO_INICIO
                                                        FROM
                                                                V_EST_PROD_CPL_ESTOQUE_PEDIDO l
                                                                JOIN #TMP_DEPO d on 
                                                                l.CD_FILIAL = d.CD_FILIAL_DEPO                                                                
                                                                INNER JOIN #TMP_PROD  P ON 
                                                                L.CD_EMP = P.CD_EMP AND
                                                                L.CD_PROD = P.CD_PROD 
                                                        WHERE        
                                                                l.CD_EMP=@CD_EMP                                                                 
                                                        GROUP BY
                                                                l.CD_PROD
                                                        HAVING  
                                                                SUM(L.QT_EST_PEND)  > 0
                                                        )
          
                 
                INSERT INTO #RS_PROD_CONSOLIDADO(CD_PROD, QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
                                                                                        QT_EST_FILIAIS_SOMA, QT_MEDIAF_SOMA, QT_RESSUP_SOMA, QT_NECESSIDADE_FILIAIS, 
                                                                                        QT_DEPOSITO_INICIO, QT_DEPOSITO, FLAG_RATEIO)
                SELECT        
                        f.CD_PROD, 
                        f.QT_UNI_RESSUPRIMENTO, 
                        f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
                        f.QT_EST_FILIAIS_SOMA, 
                        f.QT_MEDIAF_SOMA, 
                        f.QT_RESSUP_SOMA, 
                        f.QT_NECESSIDADE_FILIAIS,                 
                        d.QT_DEPOSITO_INICIO , 
                        d.QT_DEPOSITO_INICIO QT_DEPOSITO, 
                        0 FLAG_RATEIO
                FROM 
                        FILIAIS f 
                        INNER JOIN DEPOSITO d ON 
                        d.CD_PROD=f.CD_PROD
                where
                        (f.QT_RESSUP_SOMA) >  d.QT_DEPOSITO_INICIO  ;
 
                --DELETE FROM #RS_PROD_CONSOLIDADO WHERE QT_DEPOSITO < 1; 
                 
                UPDATE E
                SET        --Necessidade (-) o que tenho no deposito
                        --QT_EST_CD_DISP = CASE WHEN e.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
                        --                                                ROUND((ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0)/e.QT_UNI_RESSUPRIMENTO),0)* e.QT_UNI_RESSUPRIMENTO  
                        --                                        ELSE ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0) END,
                        QT_EST_CD_DISP =   ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0) ,
                        E.FLAG_RATEIO=1
                FROM 
                        #RS_PROD_CONSOLIDADO  C
                        INNER JOIN #RS_AUXRAT E ON 
                        C.CD_PROD = E.CD_PROD
                WHERE 
                        QTDE_RESSUP > 0; 
                  
                --Ajusta a soma
                UPDATE s SET  
                        QT_RESSUP_SOMA=QTDE_RESSUP,
                        QT_DEPOSITO=QT_DEPOSITO_INICIO - QT_EST_CD_DISP,
                        QT_EST_CD_DISP_SOMA= QT_EST_CD_DISP,
                        FLAG_RATEIO=1
                FROM 
                        #RS_PROD_CONSOLIDADO S
                        INNER JOIN (SELECT CD_PROD, 
                                                                SUM(QTDE_RESSUP) QTDE_RESSUP , 
                                                                SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
                                                        FROM 
                                                                #RS_AUXRAT 
                                                                where QT_EST_CD_DISP >0
                                                        GROUP BY CD_PROD) E ON 
                        S.CD_PROD = E.CD_PROD ;
                
                Print 'Inicio do Rateio das quantidades do CD - Time ' +convert(varchar,getdate(),108);
                --SELECT * FROM #RS_PROD_CONSOLIDADO s where cd_prod=52783
                --SELECT * FROM #RS_AUXRAT where cd_prod=52783
                --Inicio do Rateio das quantidades do CD
                WHILE EXISTS   (SELECT * FROM #RS_PROD_CONSOLIDADO s
                                                        WHERE round(QT_EST_CD_DISP_SOMA ,0) >round(QT_DEPOSITO_INICIO,0) )
                begin
                        
                    Print 'Rateio das quantidades do CD - Time ' +convert(varchar,getdate(),108);
                        ;WITH BASE AS (SELECT 
                                                                CD_PROD,
                                                                
                                                                FATOR_AJUSTE=SIGN(round(QT_DEPOSITO_INICIO,0)-round(QT_EST_CD_DISP_SOMA ,0)) 
                                                                FROM 
                                                                        #RS_PROD_CONSOLIDADO 
                                                                WHERE 
                                                                        round(QT_DEPOSITO_INICIO,0) <> round(QT_EST_CD_DISP_SOMA,0) 
                                                                        AND FLAG_RATEIO=1)
                        UPDATE p 
                        SET  
                                QT_EST_CD_DISP = Round( CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
                                                                                        QTDE_RESSUP 
                                                                                ELSE QT_EST_CD_DISP + b.FATOR_AJUSTE  END,0),
                                FLAG_RATEIO =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
                                                                                        0  ELSE 1 END    
                        FROM 
                                #RS_AUXRAT p 
                                JOIN BASE b ON 
                                p.CD_PROD=b.CD_PROD
                        WHERE  
                                 p.CD_FILIAL = (SELECT         TOP 1 CD_FILIAL
                                                                        FROM 
                                                                                #RS_AUXRAT
                                                                        WHERE 
                                                                                CD_PROD=b.CD_PROD 
                                                                                AND FLAG_RATEIO = 1
                                                                        ORDER BY 
                                                                                b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) * 30 / 
                                                                                        CASE WHEN  QTDE_MEDIAF = 0 THEN  .001 ELSE QTDE_MEDIAF END, 
                                                                                b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) );
                        --Ajusta a soma
                        UPDATE s SET   
                                QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP 
                        FROM 
                                #RS_PROD_CONSOLIDADO S
                                INNER JOIN (SELECT CD_PROD,   
                                                                        SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
                                                                FROM 
                                                                        #RS_AUXRAT GROUP BY CD_PROD) E ON 
                                S.CD_PROD = E.CD_PROD and
                                QT_EST_CD_DISP_SOMA<>QT_EST_CD_DISP ;
                                --SELECT * FROM           
                                --#RS_PROD_CONSOLIDADO S
                                --INNER JOIN (SELECT CD_PROD,   
                                --                                        SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
                                --                                FROM 
                                --                                        #RS_AUXRAT GROUP BY CD_PROD) E ON 
                                --S.CD_PROD = E.CD_PROD 
                                --where s.cd_prod=52783
                 
                end   
                
                if @CD_DEPO_ENTREGA>0
                begin
                        UPDATE F
                        SET 
                                QT_EST_MTZ  = R.QT_EST_CD_DISP,
                                QT_EST_CD_DISP =  R.QT_EST_CD_DISP
                        FROM 
                                #TMP_DEMANDA F 
                                INNER JOIN #RS_AUXRAT R ON
                                F.CD_FILIAL  = R.CD_FILIAL AND
                                F.CD_PROD         = R.CD_PROD; 
                end
                else
                begin
                        ----Abate as quantidades de estoque que existem no CD
                        UPDATE F
                        SET 
                                QTDE_TOT        = R.QTDE_RESSUP - R.QT_EST_CD_DISP , 
                                QT_EST_MTZ  = ISNULL(R.QT_EST_MTZ,0),
                                QT_PEND_ENT = F.QT_PEND_ENT,
                                QT_EST_CD_DISP = R.QT_EST_CD_DISP 
                        FROM 
                                #TMP_DEMANDA F 
                                INNER JOIN #RS_AUXRAT R ON
                                F.CD_FILIAL  = R.CD_FILIAL AND
                                F.CD_PROD  = R.CD_PROD;                                  
                end
/*************************************************************************************************************************************/
--RATEIO DO RESTO DO ESTOQUE DO CD NA NECESSIDADE...
/*************************************************************************************************************************************/
        IF @CD_DEPO_ENTREGA > 0 
        BEGIN
                Print 'rateio do resto do estoque do cd na necessidade - Time ' +convert(varchar,getdate(),108);
                TRUNCATE TABLE #RS_AUXRAT;
                INSERT INTO   #RS_AUXRAT (CD_FILIAL,CD_PROD,EMAX,QMIN,
                                                                                QTDE_MEDIAF,QT_EST,QTDE_RESSUP, MEDIAF,
                                                                                FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
                                                                                QT_UNI_RESSUPRIMENTO,
                                                                                FLAG_RATEIO,
                                                                                QT_EST_CD_DISP,
                                                                                QT_NECESSIDADE,
                                                                                QT_EST_MTZ)        
                        SELECT 
                                        F.CD_FILIAL,
                                        F.CD_PROD,
                                        F.EMAX,
                                        F.ESEG QMIN,
                                        F.MEDIAF QTDE_MEDIAF,
                                        F.QT_EST_PEND QT_EST,
                                        ISNULL(F.NECESSIDADE,0)  QTDE_RESSUP,  
                                        F.MEDIAF,
                                        P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
                                        P.QT_UNI_RESSUPRIMENTO,
                                        0 FLAG_RATEIO,
                                        ISNULL(F.NECESSIDADE,0)  QT_EST_CD_DISP,  
                                        F.NECESSIDADE,
                                        QT_DEPOSITO_INICIO QT_EST_MTZ
                                FROM
                                        #TMP_DEMANDA F
                                        INNER JOIN #TMP_PROD P ON 
                                        F.CD_PROD = P.CD_PROD
                        
                                        JOIN (SELECT p.CD_EMP,
                                                                p.CD_PROD, 
                                                                SUM(P.QT_EST_PEND - EST_UTILIZADO) AS QT_DEPOSITO_INICIO
                                                        FROM 
                                                                V_EST_PROD_CPL_ESTOQUE_PEDIDO P
                                                                JOIN #TMP_DEPO d on 
                                                                p.CD_FILIAL = d.CD_FILIAL_DEPO
                                                                JOIN (SELECT 
                                                                                        CD_PROD , SUM(QT_EST_MTZ) EST_UTILIZADO
                                                                                        FROM #TMP_DEMANDA GROUP BY CD_PROD)  T ON  
                                                                p.CD_PROD = T.CD_PROD
                                                        WHERE 
                                                                P.CD_EMP = @CD_EMP                                                 
                                                        GROUP BY 
                                                                P.CD_EMP, 
                                                                P.CD_PROD
                                                        HAVING 
                                                                SUM(P.QT_EST_PEND - EST_UTILIZADO) > 0 ) d on 
                                        F.CD_PROD = d.CD_PROD
                                WHERE
                                        ISNULL(F.NECESSIDADE,0)  >0 ; 
 
                UPDATE #RS_AUXRAT SET QTDE_RESSUP =0 WHERE QTDE_RESSUP<1; 
                TRUNCATE TABLE #RS_PROD_CONSOLIDADO;
                ;WITH FILIAIS AS (SELECT        
                                                        CD_PROD,
                                                        QT_UNI_RESSUPRIMENTO, 
                                                        FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
                                                        QT_EST_FILIAIS_SOMA                = SUM(r.QT_EST),
                                                        QT_MEDIAF_SOMA                        = SUM(r.QTDE_MEDIAF),
                                                        QT_RESSUP_SOMA                        = SUM(ROUND(r.QTDE_RESSUP, 0)),
                                                        QT_NECESSIDADE_FILIAIS        = SUM(case when r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 then
                                                                                                                                        ROUND((r.QTDE_RESSUP/r.QT_UNI_RESSUPRIMENTO),0)*r.QT_UNI_RESSUPRIMENTO
                                                                                                                        else r.QTDE_RESSUP end) 
                                                FROM 
                                                        #RS_AUXRAT r
                                                        LEFT JOIN EST_RESSUP_NAO_CONSIDERA_EST_CD_PRC_FILIAL F ON  
                                                        R.CD_FILIAL = F.CD_FILIAL AND 
                                                        F.FLAG_HABILITADO =1
                                                WHERE
                                                        F.CD_FILIAL IS NULL
                                                GROUP BY 
                                                        r.CD_PROD, 
                                                        r.QT_UNI_RESSUPRIMENTO,
                                                        r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA),
                        DEPOSITO AS (SELECT
                                                                l.CD_PROD,
                                                                SUM(L.QT_EST_PEND-T.EST_UTILIZADO) QT_DEPOSITO_INICIO
                                                        FROM
                                                                V_EST_PROD_CPL_ESTOQUE_PEDIDO l
                                                                JOIN #TMP_DEPO d on 
                                                                l.CD_FILIAL = d.CD_FILIAL_DEPO                                                                
                                                                INNER JOIN #TMP_PROD  P ON 
                                                                L.CD_EMP = P.CD_EMP AND
                                                                L.CD_PROD = P.CD_PROD
                                                                 
                                                                JOIN (SELECT 
                                                                                        CD_PROD , SUM(QT_EST_MTZ) EST_UTILIZADO
                                                                                        FROM #TMP_DEMANDA GROUP BY CD_PROD)  T ON  
                                                                p.CD_PROD = T.CD_PROD
                                                        WHERE        
                                                                l.CD_EMP=@CD_EMP                                                                 
                                                        GROUP BY
                                                                l.CD_PROD
                                                        HAVING  
                                                                SUM(L.QT_EST_PEND-T.EST_UTILIZADO)  > 0
                                                        )
                INSERT INTO #RS_PROD_CONSOLIDADO(CD_PROD, QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
                                                                                        QT_EST_FILIAIS_SOMA, QT_MEDIAF_SOMA, QT_RESSUP_SOMA, QT_NECESSIDADE_FILIAIS, 
                                                                                        QT_DEPOSITO_INICIO, QT_DEPOSITO, FLAG_RATEIO)
                SELECT        
                        f.CD_PROD, 
                        f.QT_UNI_RESSUPRIMENTO, 
                        f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
                        f.QT_EST_FILIAIS_SOMA, 
                        f.QT_MEDIAF_SOMA, 
                        f.QT_RESSUP_SOMA, 
                        f.QT_NECESSIDADE_FILIAIS,                 
                        CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
                                ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
                        ELSE d.QT_DEPOSITO_INICIO END QT_DEPOSITO_INICIO,  
                        QT_DEPOSITO = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
                                                                ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
                                                        ELSE d.QT_DEPOSITO_INICIO END),
                        0 FLAG_RATEIO
                FROM 
                        FILIAIS f 
                        INNER JOIN DEPOSITO d ON 
                        d.CD_PROD=f.CD_PROD
                where
                        (f.QT_RESSUP_SOMA) > (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
                                                                ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
                                                        ELSE d.QT_DEPOSITO_INICIO END) ;
 
                --DELETE FROM #RS_PROD_CONSOLIDADO WHERE QT_DEPOSITO < 1; 
                 
                UPDATE E
                SET        --Necessidade (-) o que tenho no deposito
                        QT_EST_CD_DISP = CASE WHEN e.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
                                                                        ROUND((ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0)/e.QT_UNI_RESSUPRIMENTO),0)* e.QT_UNI_RESSUPRIMENTO  
                                                                ELSE ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0) END,
                        E.FLAG_RATEIO=1
                FROM 
                        #RS_PROD_CONSOLIDADO  C
                        INNER JOIN #RS_AUXRAT E ON 
                        C.CD_PROD = E.CD_PROD
                WHERE 
                        QTDE_RESSUP > 0; 
                 
                --Ajusta a soma
                UPDATE s SET  
                        QT_RESSUP_SOMA=QTDE_RESSUP,
                        QT_DEPOSITO=QT_DEPOSITO_INICIO - QT_EST_CD_DISP,
                        QT_EST_CD_DISP_SOMA= QT_EST_CD_DISP,
                        FLAG_RATEIO=1
                FROM 
                        #RS_PROD_CONSOLIDADO S
                        INNER JOIN (SELECT CD_PROD, 
                                                                SUM(QTDE_RESSUP) QTDE_RESSUP , 
                                                                SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
                                                        FROM 
                                                                #RS_AUXRAT GROUP BY CD_PROD) E ON 
                        S.CD_PROD = E.CD_PROD ;
                
                Print 'Inicio do Rateio das quantidades do CD - Time ' +convert(varchar,getdate(),108);
                        --Inicio do Rateio das quantidades do CD
                        WHILE EXISTS   (SELECT * FROM #RS_PROD_CONSOLIDADO s
                                                                WHERE round(QT_EST_CD_DISP_SOMA ,0)<>round(QT_DEPOSITO_INICIO,0) )
                        begin
        
                                WITH BASE AS (SELECT 
                                                                        CD_PROD, 
                                                                        FATOR_AJUSTE=CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
                                                                                                        QT_UNI_RESSUPRIMENTO * (case when QT_DEPOSITO_INICIO < QT_EST_CD_DISP_SOMA then -1 else 1 end)
                                                                                                        ELSE SIGN(round(QT_DEPOSITO_INICIO,0)-round(QT_EST_CD_DISP_SOMA ,0)) 
                                                                                                        END 
                                                                        FROM 
                                                                                #RS_PROD_CONSOLIDADO 
                                                                        WHERE round(QT_DEPOSITO_INICIO,0) <> round(QT_EST_CD_DISP_SOMA,0) 
                                                                                AND FLAG_RATEIO=1)
                                UPDATE p 
                                SET  
                                        QT_EST_CD_DISP = Round( CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
                                                                                                CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
                                                                                                        CEILING( QTDE_RESSUP/QT_UNI_RESSUPRIMENTO ) *  QT_UNI_RESSUPRIMENTO 
                                                                                                else        QTDE_RESSUP  end 
                                                                                ELSE QT_EST_CD_DISP + b.FATOR_AJUSTE  END,0),
                                        FLAG_RATEIO =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
                                                                                                0  ELSE 1 END    
                                FROM 
                                        #RS_AUXRAT p 
                                        JOIN BASE b ON 
                                        p.CD_PROD=b.CD_PROD
                                WHERE  P.FLAG_RATEIO = 1 AND p.CD_FILIAL = (SELECT         TOP 1 CD_FILIAL
                                                                                FROM 
                                                                                        #RS_AUXRAT
                                                                                WHERE 
                                                                                        CD_PROD=b.CD_PROD 
                                                                                        AND FLAG_RATEIO = 1
                                                                                ORDER BY 
                                                                                        b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) * 30 / 
                                                                                                CASE WHEN  QTDE_MEDIAF = 0 THEN  .001 ELSE QTDE_MEDIAF END, 
                                                                                        b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) );
                                --Ajusta a soma
                                UPDATE s SET   
                                        QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP 
                                FROM 
                                        #RS_PROD_CONSOLIDADO S
                                        INNER JOIN (SELECT CD_PROD,   
                                                                                SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
                                                                        FROM 
                                                                                #RS_AUXRAT GROUP BY CD_PROD) E ON 
                                        S.CD_PROD = E.CD_PROD and
                                        QT_EST_CD_DISP_SOMA<>QT_EST_CD_DISP ;
                        end 
                        UPDATE F
                        SET 
                        --        SUGESTAO        = SUGESTAO- R.QT_EST_CD_DISP ,
                                QT_EST_MTZ  = F.QT_EST_MTZ+ R.QT_EST_CD_DISP,
                                QT_EST_CD_DISP = F.QT_EST_MTZ+ R.QT_EST_CD_DISP
                        FROM 
                                #TMP_DEMANDA F 
                                INNER JOIN #RS_AUXRAT R ON
                                F.CD_FILIAL  = R.CD_FILIAL AND
                                F.CD_PROD         = R.CD_PROD; 
                                --SELECT * FROM #TMP_DEMANDA;
                END
/*************************************************************************************************************************************/
 
        end
         
/*************************************************************************************************************************************/
/*************************************************************************************************************************************/
/*************************************************************************************************************************************/
 
        print 'Calcula a necessidade das lojas        ' + convert(varchar(10),getdate(),108);
        /***********************************************************************************/
        --sugestao
        /***********************************************************************************/
        if @CD_DEPO_ENTREGA>0
        begin
                UPDATE D
                SET
                        SUGESTAO = SUGESTAO - QT_EST_CD_DISP
                FROM 
                        #TMP_DEMANDA D;
        end
        else
        begin
                UPDATE D
                SET
                        SUGESTAO = SUGESTAO - (case when @CONSIDERA_EST_CD =1 then QT_EST_CD_DISP else 0 end)
                FROM 
                        #TMP_DEMANDA D
				WHERE 
						QT_EST_CD_DISP > 0
						
                /*UPDATE D SET 
                            NECESSIDADE = NECESSIDADE-(SUGESTAO*-1),
                            SUGESTAO = 0 
                FROM 
                        #TMP_DEMANDA D
                WHERE
                        SUGESTAO < 0;
						
				UPDATE D
                SET
                        NECESSIDADE = 0
                FROM 
                        #TMP_DEMANDA D 
				WHERE NECESSIDADE < 0;*/
        end
        /***********************************************************************************/
        --Excesso
        /***********************************************************************************/
       /* if @CD_DEPO_ENTREGA =0
        begin
                UPDATE D
                SET
                        NECESSIDADE = 0
                FROM 
                        #TMP_DEMANDA D
                WHERE         
                        QT_EST > MAX_EMAX;        
        end*/
  
                 
        /***********************************************************************************/             
        -- Aplica o Limitador
        /*UPDATE D
        SET
                NECESSIDADE = CASE WHEN (QTDE_LIMITADOR - QT_EST) < 0 THEN 0 
                                                        ELSE QTDE_LIMITADOR - QT_EST END  ,
                SUGESTAO=0
        FROM 
                #TMP_DEMANDA D
        WHERE
                SUGESTAO+NECESSIDADE > 0 
                AND QTDE_LIMITADOR > 0 
                AND SUGESTAO+NECESSIDADE+ QT_EST> QTDE_LIMITADOR ;*/
        /***********************************************************************************/
        UPDATE D
        SET
                QTDE_NECESSIDADE        = ROUND(ISNULL(D.NECESSIDADE,0),0) +ROUND(ISNULL(D.SUGESTAO,0),3),
                QTDE_TOT                        = ROUND(ISNULL(D.NECESSIDADE,0),0) +ROUND(ISNULL(D.SUGESTAO,0),3)
        FROM 
                #TMP_DEMANDA D;
				
		IF @CD_DEPO_ENTREGA = 0
		BEGIN
			UPDATE #TMP_DEMANDA SET QTDE_NECESSIDADE = 0, QTDE_TOT = 0 WHERE QTDE_TOT < 0
			UPDATE #TMP_DEMANDA SET QT_EST_CD_DISP = 0 WHERE QT_EST_CD_DISP < 0
		END
        print 'Ajustou a necessidade das lojas        ' + convert(varchar(10),getdate(),108);
        
/**********************************************************************************************************************************************************************/
IF @PED_QTD_DEF = 1
BEGIN
     Print 'Pedido com quantidades definidas'
        UPDATE I SET QTDE_TOT=0 FROM  #TMP_DEMANDA I;
        DECLARE @CD_PROD_DEF INT ;
        DECLARE @CD_FILIAL_DEF INT ;
        WHILE EXISTS
        (SELECT TOP 1 CD_PROD
                FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA 
                WHERE QTDE > QTDE_RAT
                        AND CD_USU= @CD_USU)
        BEGIN
                -- print @CD_PROD_DEF 
                -- print @CD_FILIAL_DEF
                SET @CD_PROD_DEF = (SELECT TOP 1 CD_PROD
                                                                FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA 
                                                                WHERE QTDE <> QTDE_RAT
                                                                AND CD_USU= @CD_USU)
                                                                 
                SET @CD_FILIAL_DEF=(SELECT TOP 1 CD_FILIAL  FROM #TMP_DEMANDA I
                                                        WHERE  CD_PROD =@CD_PROD_DEF
                                                        ORDER BY 
                                                                ROUND(((i.QT_EST+ isnull(I.QTDE_TOT,0)+1)/
                                                                        (CASE WHEN i.MEDIAF > 0 THEN  i.MEDIAF
                                                                        ELSE 0.0001 END))*30.000,4) ASC
                                                        );
                UPDATE I
                SET
                        QTDE_TOT=QTDE_TOT+1
                FROM 
                        #TMP_DEMANDA I
                WHERE
                        CD_PROD=@CD_PROD_DEF
                        AND CD_FILIAL = @CD_FILIAL_DEF; 
                 UPDATE D
                 SET
                        QTDE_RAT= QTDE_RAT+1
                 FROM 
                        EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA D
                WHERE 
                        CD_PROD=@CD_PROD_DEF
                        AND CD_USU= @CD_USU; 
           --select * from #TMP_DEMANDA
        END 
END
/********************************************************************************************************************************************************************/
IF @PED_QTD_DEF = 2
BEGIN
    Print 'Pedido com quantidades definidas para as filiais'
        UPDATE I SET QTDE_TOT=0 FROM  #TMP_DEMANDA I;
        
        UPDATE D
        SET
        D.QTDE_TOT = T.QTDE_PROD,
        D.VLR_PROD = T.VLR_PROD,
        D.PERC_DESC = T.PERC_DESC
        FROM #TMP_DEMANDA D
        INNER JOIN EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA_POR_FILIAL T ON
        D.CD_USU = T.CD_USU AND D.CD_PROD = T.CD_PROD AND D.CD_FILIAL = T.CD_FILIAL
END
/**************************************************************************/
/******************* Resultado final da rotina ****************************/
/**************************************************************************/
        print 'Insere a demanda final ' + convert(varchar(10),getdate(),108)
        
        --SELECT TOP 20 * FROM #TMP_DEMANDA
        INSERT INTO EST_PROD_SUPRIMENTO_ENTREGA_LOJA (CD_EMP, CD_FILIAL, CD_PROD,
                                                                                                        CD_USU, QTDE_SUGESTAO, QTDE_NECESSIDADE,
                                                                                                        QTDE_ESTOQUE, QTDE_PAR_FACE_FINAN_EMAX, QTDE_LIMITADOR,
                                                                                                        CONSIDERA_EST_CD, CD_COND_COMPRA, QTDE_PROD,
                                                                                                        VLR_PROD, PERC_DESC, CD_SIGLA,
                                                                                                        MEDIAF, QT_EST, QT_EST_PEND,
                                                                                                        QT_EST_MTZ, MAX_EMAX, EMAX,
                                                                                                        ESEG, FACE, FINA,
                                                                                                        LIMITADOR, QT_PEND_ENT, VLR_TABELA, 
                                                                                                        DT_CAD,
                                                                                                        QTDE_PROD_ORIGINAL, EMAX_D, ESEG_D,
                                                                                                        PARAM_EST, CD_AGENDA, CD_DEPO_ENTREGA,
                                                                                                        PARAM_EST_AA, PARAM_EST_A, PARAM_EST_B,
                                                                                                        PARAM_EST_C, PARAM_EST_D, CD_SIGLA_CURVA,
                                                                                                        TIPO_COMPRA, TP_REQ, LEAD_TIME,
                                                                                                        DT_PROX_AGENDA, ACRES_DIAS_PROX_AGENDA, LISTA_PRECO,
                                                                                                        CONSIDERA_FACE, NAO_UTILIZA_AGD_FACE, LISTA_FILIAIS,
                                                                                                        QT_EST_CD_DISP, QT_PEND_ENT_DEP,
                                                                                                        QT_EST_DEPOSITO, LISTA_DEPOSITO, QT_PEND_SAI,
                                                                                                        IGNORAR_EXCESSO_DEMANDA_INTEGRADA,VLR_PROD_ORIGINAL,PERC_DESC_ORIGINAL)
        SELECT
                I.CD_EMP,
                I.CD_FILIAL,
                I.CD_PROD,
                I.CD_USU, 
                isnull(I.SUGESTAO,0) SUGESTAO,
                ROUND(isnull(I.NECESSIDADE,0),0) NECESSIDADE, 
                isnull(I.QT_EST,0),
                isnull(I.MAX_EMAX,0),
                ROUND(isnull(I.QTDE_LIMITADOR,0),0),
                @CONSIDERA_EST_CD,
                i.CD_COND_COMPRA,
                i.QTDE_TOT QTDE_PROD,
                case when ISNULL(D.VLR_PROD,0) > 0 then ISNULL(D.VLR_PROD,0) else i.VLR_PROD end VLR_PROD, 
                case when ISNULL(D.PERC_DESC,0) > 0 then ISNULL(D.PERC_DESC,0)
                        else 
                                case when ISNULL(i.PERC_DESC,0) > 0 then ISNULL(i.PERC_DESC,0) else ISNULL(P.PERC_DESC_FABRICA,0) end
                        end PERC_DESC, 
                i.CD_SIGLA,
                i.MEDIAF,
                i.QT_EST_REAL,
                i.QT_EST_PEND,
                i.QT_EST_MTZ,
                i.MAX_EMAX,
                i.EMAX,
                i.ESEG,
                i.FACE,
                i.FINA,
                i.LIMITADOR,
                i.QT_PEND_ENT,
                i.VLR_TABELA,
                GETDATE(),
                i.QTDE_TOT QTDE_PROD_ORIGINAL,
                EMAX_D,
                ESEG_D,
                (CASE WHEN i.CD_SIGLA = 5 THEN @PAR_EST_AA
                        WHEN i.CD_SIGLA = 1 THEN @PAR_EST_A
                        WHEN i.CD_SIGLA = 2 THEN @PAR_EST_B
                        WHEN i.CD_SIGLA = 3 THEN @PAR_EST_C
                        WHEN i.CD_SIGLA = 4 THEN @PAR_EST_D END) PARAM_EST,
                @CD_AGENDA,
                @CD_DEPO_ENTREGA,
                @PAR_EST_AA_VLR,
                @PAR_EST_A_VLR,
                @PAR_EST_B_VLR,
                @PAR_EST_C_VLR,
                @PAR_EST_D_VLR,
                @CD_SIGLA_CURVA,
                @TIPO_COMPRA,
                @TP_REQ,
                @LEAD_TIME,
                @DT_PROX_AGENDA,
                @ACRES_DIAS_PROX_AGENDA,
                @LISTA_PRECO,
                @CONSIDERA_FACE,
                @NAO_UTILIZA_AGD_FACE,
                @CD_FILIAL AS LISTA_FILIAIS,
                I.QT_EST_CD_DISP, 
                I.QT_PEND_ENT_DEP,
                I.QT_EST_DEPOSITO,
                @CD_DEPOSITOS,
                I.QT_PEND_SAI,
                @IGNORAR_EXCESSO,
                case when ISNULL(D.VLR_PROD,0) > 0 then ISNULL(D.VLR_PROD,0) else i.VLR_PROD end VLR_PROD, 
                case when ISNULL(D.PERC_DESC,0) > 0 then ISNULL(D.PERC_DESC,0)
                        else 
                                case when ISNULL(i.PERC_DESC,0) > 0 then ISNULL(i.PERC_DESC,0) else ISNULL(P.PERC_DESC_FABRICA,0) end
                        end PERC_DESC
        FROM
                #TMP_DEMANDA  I
                LEFT JOIN EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA D ON
                I.CD_EMP = D.CD_EMP AND
                I.CD_PROD = D.CD_PROD AND
                D.CD_USU = @CD_USU
                
                INNER JOIN EST_PROD P ON
                I.CD_EMP = P.CD_EMP AND
                I.CD_PROD = P.CD_PROD

		INSERT INTO EST_PROD_SUPRIMENTO_ENTREGA_LOJA_PARAM
		(CD_EMP, CD_USU, LISTA_PRODUTO)
		VALUES
		(@CD_EMP, @CD_USU, @RELA_CD_PROD)

        DELETE 
                FROM 
                        EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA        
                WHERE CD_USU = @CD_USU;
        DELETE 
                FROM 
                        EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA_POR_FILIAL        
                WHERE CD_USU = @CD_USU;
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_SIGLA') AND type in (N'U'))
BEGIN
        DROP TABLE #RS_SIGLA
END
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_AGD_FACE') AND type in (N'U'))
BEGIN
        DROP TABLE #RS_AGD_FACE
END 
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#TMP_DEMANDA') AND type in (N'U'))
BEGIN
        DROP TABLE #TMP_DEMANDA
END
IF  OBJECT_ID('TEMPDB.DBO.#TMP_PROD') IS NOT NULL
BEGIN
        DROP TABLE #TMP_PROD
END 